<div class="ste-m-0 stax-main <?php echo esc_attr( implode( ' ', $wrapper_class ) ); ?>">
	<div class="ste-mt-5 ste-mb-4">
		<div class="ste-container ste-mx-auto ste-bg-white ste-rounded ste-shadow-lg ste-overflow-hidden">
			<div class="ste-flex ste-justify-between ste-items-center ste-p-10">
				<a href="<?php echo esc_url( $site_url ); ?>" target="_blank" rel="noopener"
				   class="ste-text-base ste-flex ste-items-center ste-content-center ste-no-underline">
					<span class="ste-inline-block ste-w-32">
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 416 185"><defs><style>.a{filter:url(#a);}.b{fill:url(#b);}.c{filter:url(#c);}.d{fill:#fff;}</style><filter id="a" x="-96.5" y="-80.8" width="293.1" height="293.1" name="filter-3"><feOffset result="shadowOffsetOuter1" dy="8" in="SourceAlpha"/><feGaussianBlur result="shadowBlurOuter1" stdDeviation="15" in="shadowOffsetOuter1"/><feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.16 0" in="shadowBlurOuter1"/></filter><linearGradient id="b" x1="-382.3" y1="830.06" x2="-383.3" y2="829.06" gradientTransform="matrix(50.76, 0, 0, -50.76, 19570.16, 42133.68)" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#f1295b"/><stop offset="1" stop-color="#2f2975"/></linearGradient><filter id="c" x="-127.9" y="-110.2" width="355.7" height="355.7" name="filter-5"><feOffset result="shadowOffsetOuter1" dy="4" in="SourceAlpha"/><feGaussianBlur result="shadowBlurOuter1" stdDeviation="9" in="shadowOffsetOuter1"/><feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.17 0" in="shadowBlurOuter1"/></filter></defs><title>stax-addons-blacker</title><path d="M60.6,49.63,85.43,34.51C87.5,33.24,88,31,86.5,29.38a5.38,5.38,0,0,0-6.44-.55L55.24,44c-2.08,1.26-2.56,3.56-1.08,5.13A5.38,5.38,0,0,0,60.6,49.63Z"/><path d="M77.27,165a4.15,4.15,0,0,0,4.09-4.2V101l50.25-29.9a4.28,4.28,0,0,0,1.49-5.75,4,4,0,0,0-5.57-1.54L77.27,93.71,27,63.81a4,4,0,0,0-5.57,1.54,4.28,4.28,0,0,0,1.49,5.75L73.19,101v59.8a4.14,4.14,0,0,0,4.08,4.2Z"/><path d="M.53,103.16v32.09a11.71,11.71,0,0,0,5.82,10.11l64.54,37.33a11.66,11.66,0,0,0,11.65,0l64.54-37.33a11.71,11.71,0,0,0,5.82-10.11V107.19a4.15,4.15,0,0,0-8.3,0v28.06a3.37,3.37,0,0,1-1.67,2.91L78.39,175.49a3.34,3.34,0,0,1-3.35,0L10.5,138.16a3.37,3.37,0,0,1-1.67-2.91V60.59a3.36,3.36,0,0,1,1.67-2.9L75,20.36a3.34,3.34,0,0,1,3.35,0l64.54,37.33a3.36,3.36,0,0,1,1.67,2.9v27.2a4.15,4.15,0,1,0,8.3,0V60.59a11.69,11.69,0,0,0-5.82-10.1L82.54,13.16a11.66,11.66,0,0,0-11.65,0L46.07,27.51l-8.29,4.8L6.35,50.49A11.69,11.69,0,0,0,.53,60.59v42.57Z"/><path d="M204.17,107.26a20.4,20.4,0,0,1-7.14-3.55,3.59,3.59,0,0,1-1.47-3.07,3.65,3.65,0,0,1,.8-2.34,2.36,2.36,0,0,1,1.89-1,5.16,5.16,0,0,1,2.62.9,19.45,19.45,0,0,0,5.76,2.88,23.23,23.23,0,0,0,6.66.89q4.67,0,7.17-1.63A5.35,5.35,0,0,0,223,95.58a4.1,4.1,0,0,0-2.33-3.74,31.12,31.12,0,0,0-7.78-2.53,46.22,46.22,0,0,1-9.15-2.81,12.93,12.93,0,0,1-5.31-4.1,10.57,10.57,0,0,1-1.8-6.34,11.94,11.94,0,0,1,2.24-7.1,14.9,14.9,0,0,1,6.24-4.9,22.2,22.2,0,0,1,9-1.76q9.15,0,14.91,4.87a4.89,4.89,0,0,1,1.18,1.37,4,4,0,0,1-.45,4,2.36,2.36,0,0,1-1.88,1,3.76,3.76,0,0,1-1.19-.19,10.25,10.25,0,0,1-1.44-.71,21.56,21.56,0,0,0-5.09-2.85,17.4,17.4,0,0,0-6-.92,11.78,11.78,0,0,0-6.88,1.76,5.61,5.61,0,0,0-2.53,4.89,4.47,4.47,0,0,0,2.24,4,26.12,26.12,0,0,0,7.61,2.63,50.6,50.6,0,0,1,9.25,2.85,13.58,13.58,0,0,1,5.44,4,9.59,9.59,0,0,1,1.89,6.08,11.6,11.6,0,0,1-2.21,7,14.34,14.34,0,0,1-6.21,4.74,23.3,23.3,0,0,1-9.18,1.7A32.08,32.08,0,0,1,204.17,107.26Z"/><path d="M264,107.2a4,4,0,0,1-1.12-3V69.66H251.24q-3.84,0-3.84-3.39t3.84-3.39h31.55q3.84,0,3.84,3.39t-3.84,3.39H271.14v34.56a3.85,3.85,0,0,1-4.09,4.1A4.08,4.08,0,0,1,264,107.2Z"/><path d="M341.74,104.74a3.17,3.17,0,0,1-1.19,2.49,4,4,0,0,1-2.72,1,3.68,3.68,0,0,1-1.92-.55A3.62,3.62,0,0,1,334.5,106l-3.84-8.58H308.13L304.29,106a3.66,3.66,0,0,1-1.4,1.69,3.79,3.79,0,0,1-2,.55,4.07,4.07,0,0,1-2.69-1,3.13,3.13,0,0,1-1.21-2.49,4.05,4.05,0,0,1,.38-1.67l17.67-37.95a4.13,4.13,0,0,1,1.76-2,5.09,5.09,0,0,1,5.05,0,4.13,4.13,0,0,1,1.76,2l17.73,37.95A3.92,3.92,0,0,1,341.74,104.74ZM311,91h16.9L319.4,72Z"/><path d="M397.61,104.54a3.64,3.64,0,0,1-1.19,2.69,3.77,3.77,0,0,1-2.72,1.15,3.61,3.61,0,0,1-2.81-1.4l-13-16.13L364.84,107a3.54,3.54,0,0,1-2.75,1.34,3.82,3.82,0,0,1-2.72-1.12,3.54,3.54,0,0,1-1.19-2.66,3.75,3.75,0,0,1,1-2.43l13.95-17L359.72,68.77a3.42,3.42,0,0,1-1-2.43,3.58,3.58,0,0,1,1.15-2.66,3.72,3.72,0,0,1,2.69-1.12A3.63,3.63,0,0,1,365.41,64l12.48,15.42L390.38,64a3.43,3.43,0,0,1,2.75-1.41,3.84,3.84,0,0,1,2.72,1.12A3.57,3.57,0,0,1,397,66.34a3.42,3.42,0,0,1-1,2.43L382.69,85.09l13.89,17A3.81,3.81,0,0,1,397.61,104.54Z"/><path d="M210.75,143.67a1.31,1.31,0,0,1-.48,1,1.64,1.64,0,0,1-1.11.41,1.44,1.44,0,0,1-.78-.22,1.42,1.42,0,0,1-.57-.69l-1.56-3.48H197.1l-1.56,3.48a1.39,1.39,0,0,1-.58.69,1.48,1.48,0,0,1-.8.22,1.63,1.63,0,0,1-1.09-.41,1.3,1.3,0,0,1-.5-1,1.5,1.5,0,0,1,.16-.67l7.17-15.42a1.68,1.68,0,0,1,.72-.79,2,2,0,0,1,2,0,1.68,1.68,0,0,1,.72.79l7.2,15.42A1.64,1.64,0,0,1,210.75,143.67Zm-12.51-5.56h6.86l-3.43-7.72Z"/><path d="M231.69,144.58a1.52,1.52,0,0,1-.43-1.17V128.26a1.52,1.52,0,0,1,.43-1.17,1.61,1.61,0,0,1,1.18-.42H238a9.58,9.58,0,0,1,7,2.41,10.44,10.44,0,0,1,0,13.51,9.58,9.58,0,0,1-7,2.41h-5.15A1.61,1.61,0,0,1,231.69,144.58Zm6.12-2.31q6.31,0,6.32-6.45t-6.32-6.42h-3.2v12.87Z"/><path d="M269.29,144.58a1.52,1.52,0,0,1-.43-1.17V128.26a1.52,1.52,0,0,1,.43-1.17,1.59,1.59,0,0,1,1.18-.42h5.15a9.61,9.61,0,0,1,7,2.41,10.44,10.44,0,0,1,0,13.51,9.61,9.61,0,0,1-7,2.41h-5.15A1.59,1.59,0,0,1,269.29,144.58Zm6.12-2.31q6.31,0,6.32-6.45t-6.32-6.42h-3.2v12.87Z"/><path d="M310,144.09a7.63,7.63,0,0,1-3-3.28,10.89,10.89,0,0,1-1.07-5,11.14,11.14,0,0,1,1.05-5,7.53,7.53,0,0,1,3-3.26,10.05,10.05,0,0,1,9.3,0,7.61,7.61,0,0,1,3,3.26,11.14,11.14,0,0,1,1.06,5,11,11,0,0,1-1.07,5,7.59,7.59,0,0,1-3,3.28,10,10,0,0,1-9.26,0Zm8.58-3.28a9.46,9.46,0,0,0,0-10,4.8,4.8,0,0,0-3.93-1.73,4.86,4.86,0,0,0-4,1.73,9.46,9.46,0,0,0,0,10,4.82,4.82,0,0,0,4,1.75A4.76,4.76,0,0,0,318.55,140.81Z"/><path d="M359.74,127a1.69,1.69,0,0,1,.43,1.2v15.27a1.69,1.69,0,0,1-.45,1.22,1.63,1.63,0,0,1-2.41-.13l-9.49-12.35v11.26a1.76,1.76,0,0,1-.42,1.22,1.63,1.63,0,0,1-2.29,0,1.8,1.8,0,0,1-.41-1.22V128.2a1.62,1.62,0,0,1,.44-1.2,1.52,1.52,0,0,1,1.17-.46,1.47,1.47,0,0,1,1.25.6l9.46,12.3V128.2a1.65,1.65,0,0,1,.43-1.2,1.46,1.46,0,0,1,1.13-.46A1.5,1.5,0,0,1,359.74,127Z"/><path d="M384.67,144.7a8.2,8.2,0,0,1-2.9-1.44,1.48,1.48,0,0,1-.59-1.25,1.46,1.46,0,0,1,.32-.95,1,1,0,0,1,.77-.4,2.12,2.12,0,0,1,1.06.36,7.78,7.78,0,0,0,2.34,1.17,9.6,9.6,0,0,0,2.71.37,5.35,5.35,0,0,0,2.91-.67,2.16,2.16,0,0,0,1-1.93,1.67,1.67,0,0,0-.95-1.53,12.79,12.79,0,0,0-3.15-1,18.15,18.15,0,0,1-3.72-1.15,5.11,5.11,0,0,1-2.16-1.66,4.27,4.27,0,0,1-.73-2.57,4.82,4.82,0,0,1,.91-2.89,6,6,0,0,1,2.54-2,8.9,8.9,0,0,1,3.65-.71,9.05,9.05,0,0,1,6.06,2,2.14,2.14,0,0,1,.48.56,1.54,1.54,0,0,1,.14.69,1.51,1.51,0,0,1-.32,1,1,1,0,0,1-.77.4,1.27,1.27,0,0,1-.48-.08,3.63,3.63,0,0,1-.59-.28,8.85,8.85,0,0,0-2.06-1.16,7.06,7.06,0,0,0-2.46-.38,4.82,4.82,0,0,0-2.8.72,2.3,2.3,0,0,0-1,2,1.82,1.82,0,0,0,.91,1.64,10.71,10.71,0,0,0,3.09,1.06,20.69,20.69,0,0,1,3.76,1.16,5.61,5.61,0,0,1,2.21,1.62,3.93,3.93,0,0,1,.77,2.47,4.7,4.7,0,0,1-.9,2.85,5.82,5.82,0,0,1-2.52,1.92,9.51,9.51,0,0,1-3.73.69A13,13,0,0,1,384.67,144.7Z"/><g class="a"><path d="M162.22,0H116.54A2.53,2.53,0,0,0,114,2.54V48.22a2.53,2.53,0,0,0,2.54,2.54h45.68a2.53,2.53,0,0,0,2.54-2.54V2.54A2.53,2.53,0,0,0,162.22,0"/></g><path class="b" d="M162.22,0H116.54A2.53,2.53,0,0,0,114,2.54V48.22a2.53,2.53,0,0,0,2.54,2.54h45.68a2.53,2.53,0,0,0,2.54-2.54V2.54A2.53,2.53,0,0,0,162.22,0"/><g class="c"><path d="M132.63,14V36.72H128V14Zm18.09,18.09v4.59h-13.5V32.13Zm0-9.18v4.59h-13.5V23Zm0-8.91v4.59h-13.5V14Z"/></g><path class="d" d="M132.63,14V36.72H128V14Zm18.09,18.09v4.59h-13.5V32.13Zm0-9.18v4.59h-13.5V23Zm0-8.91v4.59h-13.5V14Z"/></svg>
					</span>
				</a>

				<div class="ste-text-right">
					<h1 class="ste-block ste-leading-normal ste-my-0"><span class="ste-font-light">Welcome to</span> STAX</h1>
					<div class="ste-font-medium ste-text-lg ste-text-gray-600">Visibility Logic for Elementor</div>
				</div>
			</div>
			<ul class="ste-flex ste-overflow-hidden ste-bg-gradient-to-r ste-from-blue-500 ste-to-indigo-500 ste-m-0">
				<?php foreach ( $menu as $item ) : ?>
					<?php
						$active_class = $item['query'] === $_GET['page'] ? 'ste-bg-blue-700' : '';
					?>
					<li class="ste-flex ste-mb-0">
						<a href="<?php echo esc_url( $item['link'] ); ?>" class="ste-no-underline ste-text-white ste-font-medium ste-py-4 ste-px-6 ste-leading-normal focus:ste-shadow-none hover:ste-bg-blue-700 hover:ste-text-white <?php echo esc_attr( $active_class ); ?>">
							<?php echo $item['name']; ?>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	</div>

	<?php do_action( STAX_VISIBILITY_HOOK_PREFIX . 'before_panel_action' ); ?>

	<?php do_action( STAX_VISIBILITY_HOOK_PREFIX . 'panel_action' ); ?>

	<?php do_action( STAX_VISIBILITY_HOOK_PREFIX . 'after_panel_action' ); ?>

	<div class="ste-container ste-mx-auto ste-my-10">
		<div class="ste-flex ste-justify-center">
			<div class="ste-text-gray-400 ste-text-sm">
				<?php printf( __( 'Version %s', 'visibility-logic-elementor' ), STAX_VISIBILITY_VERSION ); ?>
			</div>
		</div>
	</div>
</div>
